
markup.push({

// MARK: input device block

AudioDeviceInputBlock:
{
	"+": "SourceTemplate",
    geNodeClass: "AHKAudioDeviceInputNode",
	geInputRank: 3,	
    h4PresetsId: "InputDevicePresets",
	gxTitle: "Input Device",
	gxDescriptionKeyPath: "node.deviceTitleMarkup",
	gxLibraryDescription: "Capture audio from a microphone or other input",
	gxLibraryIcon: "library.input.device",
	gxPopoverInfo: "InputDevicePopover",
	gxChildViews:
	{
		deviceName: {
			"+": "LabelView.centery.lineSquash1.foreColorTheme1.size105.wrap.useMarkup",
			gxValueKey: "node.deviceTitleMarkup",
			axIsIgnored: true,		// avoid VO reading title twice (blockDescription covers it)
			axTitle: "Device name",
			gxFrameRect: "11,84,98,28",
		},
		deviceIcon: {
			nsClass: "GXDrawView",
			gxForePainter: "ImagePainter.block.input.select",
			gxValueKey: "node.deviceIcon",
			gxFrameRect: "20,36,80,48",
		},
	}
},

// MARK: - input device popover

InputDevicePopover:
{
	"+": "PopoverTemplate",
	gxTitle: "Input Device",
	gxLayout: [	"H:|-12-[self(350)]-12-|",
				"V:|-12-[self]-12-|",
				"V:|-41-[group]-6-[presetsGroup]" ],
	gxChildViews:
	{
		title: "PopoverTitle",
		onOff: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup("stripMarkup"),
		group: {
			"+": "GroupView",
			gxLayout: [
				"H:|-0-[self]-0-|",
				"H:|-12-[device]-12-|",
				"V:|-10-[title]",
				"V:|-35-[device]-14-[advancedBtn]-0-[advanced]-0-|",
			],
			gxChildViews:
			{
				title: groupTitleView("Audio Device"),
				device: {
					"+": "PopupMenuTemplate.useMarkup",
					axTitle: "Audio Device",
					gxDisableOnNil: false,
					gxHideOnNilValue: false,
					gxValueKey: "node.menuItemIdentity",
					gxDisplayValueKey: "node.deviceListTitle",
					gxMenuItemsKeyPath: "node.deviceListMenuItems",
				},
				advancedBtn: {
					"+": "AdvancedGroupButton",
					gxTitle: "<disclosure/> Advanced",
					axFormatter: disclosureAxFormatter("Advanced"),
					gxValueKey: "uiState.advancedExpanded",
				},
				advanced: {
					"+": "ExpandingGroupView.noTopStroke",
					//axIsIgnored: false,
					//axTitle: "Advanced Group",
					gxValueKey: "uiState.advancedExpanded",
					gxCollapsible: true,
					gxCollapsedSize: 1,	// lets bottom stroke show
					gxExtraSize: 12,
					gxLayout: [
						"H:|-0-[self]-0-|",
						"H:[leftLabel]-[left(160)]-24-|&alignBaseline",
						"H:[rightLabel]-[right(160)]-24-|&alignBaseline",
						"V:|-8-[left]-8-[right]",
					],
					gxChildViews:
					{
						left: {
							"+": "PopupMenuTemplate",
							gxValueKey: "node.leftChannel",
							gxMenuItemsKeyPath: "node.channelMenuItems",
							axTitle: "Left Channel",
						},
						leftLabel: labelView("Left Channel:"),
						right: {
							"+": "PopupMenuTemplate",
							gxValueKey: "node.rightChannel",
							gxMenuItemsKeyPath: "node.channelMenuItems",
							axTitle: "Right Channel",
						},
						rightLabel: labelView("Right Channel:"),
					}
				}
			}
		}
	}
},



})
